/*
 * Globalize Culture ko
 *
 * http://github.com/jquery/globalize
 *
 * Copyright Software Freedom Conservancy, Inc.
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * http://jquery.org/license
 *
 * This file was generated by the Globalize Culture Generator
 * Translation: bugs found in this file need to be fixed in the generator
 */

(function( window, undefined ) {

var Globalize;

if ( typeof require !== "undefined" &&
	typeof exports !== "undefined" &&
	typeof module !== "undefined" ) {
	// Assume CommonJS
	Globalize = require( "globalize" );
} else {
	// Global variable
	Globalize = window.Globalize;
}

Globalize.addCultureInfo( "ko", "default", {
	name: "ko",
	englishName: "Korean",
	nativeName: "한국어",
	language: "ko",
	numberFormat: {
		currency: {
			pattern: ["-$n","$n"],
			decimals: 0,
			symbol: "₩"
		}
	},
	calendars: {
		standard: {
			"/": "-",
			days: {
				names: ["일요일","월요일","화요일","수요일","목요일","금요일","토요일"],
				namesAbbr: ["일","월","화","수","목","금","토"],
				namesShort: ["일","월","화","수","목","금","토"]
			},
			months: {
				names: ["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월",""],
				namesAbbr: ["1","2","3","4","5","6","7","8","9","10","11","12",""]
			},
			AM: ["오전","오전","오전"],
			PM: ["오후","오후","오후"],
			eras: [{"name":"서기","start":null,"offset":0}],
			patterns: {
				d: "yyyy-MM-dd",
				D: "yyyy'년' M'월' d'일' dddd",
				t: "tt h:mm",
				T: "tt h:mm:ss",
				f: "yyyy'년' M'월' d'일' dddd tt h:mm",
				F: "yyyy'년' M'월' d'일' dddd tt h:mm:ss",
				M: "M'월' d'일'",
				Y: "yyyy'년' M'월'"
			}
		},
		Korean: {
			name: "Korean",
			"/": "-",
			days: {
				names: ["일요일","월요일","화요일","수요일","목요일","금요일","토요일"],
				namesAbbr: ["일","월","화","수","목","금","토"],
				namesShort: ["일","월","화","수","목","금","토"]
			},
			months: {
				names: ["1월","2월","3월","4월","5월","6월","7월","8월","9월","10월","11월","12월",""],
				namesAbbr: ["1","2","3","4","5","6","7","8","9","10","11","12",""]
			},
			AM: ["오전","오전","오전"],
			PM: ["오후","오후","오후"],
			eras: [{"name":"단기","start":null,"offset":-2333}],
			twoDigitYearMax: 4362,
			patterns: {
				d: "gg yyyy-MM-dd",
				D: "gg yyyy'년' M'월' d'일' dddd",
				t: "tt h:mm",
				T: "tt h:mm:ss",
				f: "gg yyyy'년' M'월' d'일' dddd tt h:mm",
				F: "gg yyyy'년' M'월' d'일' dddd tt h:mm:ss",
				M: "M'월' d'일'",
				Y: "gg yyyy'년' M'월'"
			}
		}
	}
});

}( this ));
(function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}
var dict = {
  "box user": "사용자",
  "filetype_box user": "사용자",
  "html": "HTML 파일",
  "filetype_html": "HTML 파일",
  "wiki": "위키",
  "filetype_wiki": "위키",
  "webscraperwebpage": "웹 페이지",
  "filetype_webscraperwebpage": "웹 페이지",
  "image": "이미지",
  "filetype_image": "이미지",
  "folder": "폴더",
  "filetype_folder": "폴더",
  "txt": "텍스트",
  "filetype_txt": "텍스트",
  "zip": "Zip 파일",
  "filetype_zip": "Zip 파일",
  "olefile": "OLE 파일",
  "filetype_olefile": "OLE 파일",
  "gmailmessage": "Gmail 메시지",
  "filetype_gmailmessage": "Gmail 메시지",
  "pdf": "PDF 파일",
  "filetype_pdf": "PDF 파일",
  "swf": "플래시 파일",
  "filetype_swf": "플래시 파일",
  "xml": "XML 파일",
  "filetype_xml": "XML 파일",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS 피드",
  "filetype_rssitem": "RSS 피드",
  "doc": "문서",
  "filetype_doc": "문서",
  "docx": "마이크로소프트 워드 문서",
  "filetype_docx": "마이크로소프트 워드 문서",
  "xls": "스프레드시트 문서",
  "filetype_xls": "스프레드시트 문서",
  "ppt": "프레젠테이션 문서",
  "filetype_ppt": "프레젠테이션 문서",
  "video": "동영상",
  "filetype_video": "동영상",
  "saleforceitem": "세일즈포스",
  "filetype_saleforceitem": "세일즈포스",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "세일즈포스",
  "filetype_salesforceitem": "세일즈포스",
  "odt": "오픈 텍스트 문서",
  "filetype_odt": "오픈 텍스트 문서",
  "lithiummessage": "Lithium 메시지",
  "filetype_lithiummessage": "Lithium 메시지",
  "lithiumthread": "Lithium 스레드",
  "filetype_lithiumthread": "Lithium 스레드",
  "lithiumboard": "Lithium 게시판",
  "filetype_lithiumboard": "Lithium 게시판",
  "lithiumcategory": "Lithium 카테고리",
  "filetype_lithiumcategory": "Lithium 카테고리",
  "lithiumcommunity": "Lithium 커뮤니티",
  "filetype_lithiumcommunity": "Lithium 커뮤니티",
  "people": "사용자",
  "objecttype_people": "사용자",
  "message": "메시지",
  "objecttype_message": "메시지",
  "feed": "RSS 피드",
  "objecttype_feed": "RSS 피드",
  "thread": "스레드",
  "objecttype_thread": "스레드",
  "file": "파일",
  "objecttype_file": "파일",
  "board": "게시판",
  "objecttype_board": "게시판",
  "category": "카테고리",
  "objecttype_category": "카테고리",
  "account": "계정",
  "objecttype_account": "계정",
  "annotation": "메모",
  "objecttype_annotation": "메모",
  "campaign": "캠페인",
  "objecttype_campaign": "캠페인",
  "case": "사례",
  "objecttype_case": "사례",
  "contact": "연락처",
  "objecttype_contact": "연락처",
  "contract": "계약",
  "objecttype_contract": "계약",
  "event": "이벤트",
  "objecttype_event": "이벤트",
  "email": "이메일",
  "objecttype_email": "이메일",
  "goal": "목표",
  "objecttype_goal": "목표",
  "incident": "사건",
  "objecttype_incident": "사건",
  "invoice": "인보이스",
  "objecttype_invoice": "인보이스",
  "lead": "잠재 고객",
  "objecttype_lead": "잠재 고객",
  "list": "목록",
  "objecttype_list": "마케팅 목록",
  "solution": "솔루션",
  "objecttype_solution": "솔루션",
  "task": "작업",
  "objecttype_task": "작업",
  "user": "사용자",
  "objecttype_user": "사용자",
  "attachment": "첨부 파일",
  "objecttype_attachment": "첨부 파일",
  "casecomment": "사례 메모",
  "objecttype_casecomment": "사례 메모",
  "opportunity": "기회",
  "objecttype_opportunity": "기회",
  "opportunityproduct": "영업 기회 제품",
  "objecttype_opportunityproduct": "영업 기회 제품",
  "feeditem": "채터",
  "objecttype_feeditem": "채터",
  "feedcomment": "채터",
  "objecttype_feedcomment": "채터",
  "note": "메모",
  "objecttype_note": "메모",
  "product": "제품",
  "objecttype_product": "제품",
  "partner": "파트너",
  "objecttype_partner": "파트너",
  "queueitem": "큐 항목",
  "objecttype_queueitem": "큐 항목",
  "quote": "견적",
  "objecttype_quote": "견적",
  "salesliterature": "영업 홍보 자료",
  "objecttype_salesliterature": "영업 홍보 자료",
  "salesorder": "판매 주문",
  "objecttype_salesorder": "판매 주문",
  "service": "서비스",
  "objecttype_service": "서비스",
  "socialprofile": "소셜 프로필",
  "objecttype_socialprofile": "소셜 프로필",
  "kbdocumentation": "문서",
  "objecttype_kbdocumentation": "문서",
  "kbtechnicalarticle": "문서",
  "objecttype_kbtechnicalarticle": "문서",
  "kbsolution": "솔루션",
  "objecttype_kbsolution": "솔루션",
  "kbknowledgearticle": "참조 문서",
  "objecttype_kbknowledgearticle": "참조 문서",
  "kbattachment": "첨부 파일",
  "objecttype_kbattachment": "첨부 파일",
  "kbarticle": "문서",
  "objecttype_kbarticle": "문서",
  "kbarticlecomment": "문서 주석",
  "objecttype_kbarticlecomment": "문서 주석",
  "knowledgearticle": "참조 문서",
  "objecttype_knowledgearticle": "참조 문서",
  "topic": "주제",
  "objecttype_topic": "주제",
  "dashboard": "대시보드",
  "objecttype_dashboard": "대시보드",
  "contentversion": "문서",
  "objecttype_contentversion": "문서",
  "collaborationgroup": "공동 작업 그룹",
  "objecttype_collaborationgroup": "공동 작업 그룹",
  "spportal": "포털",
  "filetype_spportal": "포털",
  "spsite": "사이트",
  "filetype_spsite": "사이트",
  "spuserprofile": "SharePoint 사용자",
  "filetype_spuserprofile": "SharePoint 사용자",
  "sparea": "영역",
  "filetype_sparea": "영역",
  "spannouncement": "공지 사항",
  "filetype_spannouncement": "공지 사항",
  "spannouncementlist": "공지 사항",
  "filetype_spannouncementlist": "공지 사항",
  "spcontact": "연락처",
  "filetype_spcontact": "연락처",
  "spcontactlist": "연락처",
  "filetype_spcontactlist": "연락처",
  "spcustomlist": "사용자 지정 목록",
  "filetype_spcustomlist": "사용자 지정 목록",
  "spdiscussionboard": "토론 게시판",
  "filetype_spdiscussionboard": "토론 게시판",
  "spdiscussionboardlist": "토론 게시판",
  "filetype_spdiscussionboardlist": "토론 게시판",
  "spdocumentlibrarylist": "문서 라이브러리",
  "filetype_spdocumentlibrarylist": "문서 라이브러리",
  "spevent": "이벤트",
  "filetype_spevent": "이벤트",
  "speventlist": "이벤트",
  "filetype_speventlist": "이벤트",
  "spformlibrarylist": "양식 라이브러리",
  "filetype_spformlibrarylist": "양식 라이브러리",
  "spissue": "문제",
  "filetype_spissue": "문제",
  "spissuelist": "문제",
  "filetype_spissuelist": "문제",
  "splink": "링크",
  "filetype_splink": "링크",
  "splinklist": "링크",
  "filetype_splinklist": "링크",
  "sppicturelibrarylist": "그림 라이브러리",
  "filetype_sppicturelibrarylist": "그림 라이브러리",
  "spsurvey": "설문 조사",
  "filetype_spsurvey": "설문 조사",
  "spsurveylist": "설문 조사",
  "filetype_spsurveylist": "설문 조사",
  "sptask": "작업",
  "filetype_sptask": "작업",
  "sptasklist": "작업",
  "filetype_sptasklist": "작업",
  "spagenda": "회의록",
  "filetype_spagenda": "회의록",
  "spagendalist": "회의록",
  "filetype_spagendalist": "회의록",
  "spattendee": "참석자",
  "filetype_spattendee": "참석자",
  "spattendeelist": "참석자",
  "filetype_spattendeelist": "참석자",
  "spcustomgridlist": "사용자 지정 눈금",
  "filetype_spcustomgridlist": "사용자 지정 눈금",
  "spdecision": "결정 사항",
  "filetype_spdecision": "결정 사항",
  "spdecisionlist": "결정 사항",
  "filetype_spdecisionlist": "결정 사항",
  "spobjective": "목표",
  "filetype_spobjective": "목표",
  "spobjectivelist": "목표",
  "filetype_spobjectivelist": "목표",
  "sptextbox": "텍스트 상자",
  "filetype_sptextbox": "텍스트 상자",
  "sptextboxlist": "텍스트 상자 목록",
  "filetype_sptextboxlist": "텍스트 상자 목록",
  "spthingstobring": "필요한 것",
  "filetype_spthingstobring": "필요한 것",
  "spthingstobringlist": "필요한 것",
  "filetype_spthingstobringlist": "필요한 것",
  "sparealisting": "영역 목록",
  "filetype_sparealisting": "영역 목록",
  "spmeetingserie": "모임 되풀이 항목",
  "filetype_spmeetingserie": "모임 되풀이 항목",
  "spmeetingserielist": "모임 되풀이 항목 목록",
  "filetype_spmeetingserielist": "모임 되풀이 항목 목록",
  "spsitedirectory": "사이트 디렉터리 항목",
  "filetype_spsitedirectory": "사이트 디렉터리 항목",
  "spsitedirectorylist": "사이트 디렉터리",
  "filetype_spsitedirectorylist": "사이트 디렉터리",
  "spdatasource": "데이터 원본",
  "filetype_spdatasource": "데이터 원본",
  "spdatasourcelist": "데이터 원본 목록",
  "filetype_spdatasourcelist": "데이터 원본 목록",
  "splisttemplatecataloglist": "목록 서식 파일 갤러리",
  "filetype_splisttemplatecataloglist": "목록 서식 파일 갤러리",
  "spwebpartcataloglist": "웹 파트 갤러리",
  "filetype_spwebpartcataloglist": "웹 파트 갤러리",
  "spwebtemplatecataloglist": "사이트 서식 파일 갤러리",
  "filetype_spwebtemplatecataloglist": "사이트 서식 파일 갤러리",
  "spworkspacepagelist": "작업 영역 페이지",
  "filetype_spworkspacepagelist": "작업 영역 페이지",
  "spunknownlist": "사용자 지정 목록",
  "filetype_spunknownlist": "사용자 지정 목록",
  "spadministratortask": "관리자 작업",
  "filetype_spadministratortask": "관리자 작업",
  "spadministratortasklist": "관리자 작업",
  "filetype_spadministratortasklist": "관리자 작업",
  "spareadocumentlibrarylist": "영역 문서 라이브러리",
  "filetype_spareadocumentlibrarylist": "영역 문서 라이브러리",
  "spblogcategory": "블로그 카테고리",
  "filetype_spblogcategory": "블로그 카테고리",
  "spblogcategorylist": "블로그 카테고리",
  "filetype_spblogcategorylist": "블로그 카테고리",
  "spblogcomment": "블로그 메모",
  "filetype_spblogcomment": "블로그 메모",
  "spblogcommentlist": "블로그 메모",
  "filetype_spblogcommentlist": "블로그 메모",
  "spblogpost": "블로그 게시물",
  "filetype_spblogpost": "블로그 게시물",
  "spblogpostlist": "블로그 게시물",
  "filetype_spblogpostlist": "블로그 게시물",
  "spdataconnectionlibrarylist": "데이터 연결 라이브러리",
  "filetype_spdataconnectionlibrarylist": "데이터 연결 라이브러리",
  "spdistributiongroup": "메일 그룹",
  "filetype_spdistributiongroup": "메일 그룹",
  "spdistributiongrouplist": "메일 그룹",
  "filetype_spdistributiongrouplist": "메일 그룹",
  "spipfslist": "InfoPath 양식 서버",
  "filetype_spipfslist": "InfoPath 양식 서버",
  "spkeyperformanceindicator": "핵심 성과 지표",
  "filetype_spkeyperformanceindicator": "핵심 성과 지표",
  "spkeyperformanceindicatorlist": "핵심 성과 지표",
  "filetype_spkeyperformanceindicatorlist": "핵심 성과 지표",
  "splanguagesandtranslator": "언어와 번역기",
  "filetype_splanguagesandtranslator": "언어와 번역기",
  "splanguagesandtranslatorlist": "언어와 번역기",
  "filetype_splanguagesandtranslatorlist": "언어와 번역기",
  "spmasterpagescataloglist": "마스터 페이지 갤러리",
  "filetype_spmasterpagescataloglist": "마스터 페이지 갤러리",
  "spnocodeworkflowlibrarylist": "코드 없는 워크플로 라이브러리",
  "filetype_spnocodeworkflowlibrarylist": "코드 없는 워크플로 라이브러리",
  "spprojecttask": "프로젝트 작업",
  "filetype_spprojecttask": "프로젝트 작업",
  "spprojecttasklist": "프로젝트 작업",
  "filetype_spprojecttasklist": "프로젝트 작업",
  "sppublishingpageslibrarylist": "페이지 라이브러리",
  "filetype_sppublishingpageslibrarylist": "페이지 라이브러리",
  "spreportdocumentlibrarylist": "보고서 문서 라이브러리",
  "filetype_spreportdocumentlibrarylist": "보고서 문서 라이브러리",
  "spreportlibrarylist": "보고서 라이브러리",
  "filetype_spreportlibrarylist": "보고서 라이브러리",
  "spslidelibrarylist": "슬라이드 라이브러리",
  "filetype_spslidelibrarylist": "슬라이드 라이브러리",
  "sptab": "탭",
  "filetype_sptab": "탭",
  "sptablist": "탭 목록",
  "filetype_sptablist": "탭 목록",
  "sptranslationmanagementlibrarylist": "번역 관리 라이브러리",
  "filetype_sptranslationmanagementlibrarylist": "번역 관리 라이브러리",
  "spuserinformation": "사용자 정보",
  "filetype_spuserinformation": "사용자 정보",
  "spuserinformationlist": "사용자 정보 목록",
  "filetype_spuserinformationlist": "사용자 정보 목록",
  "spwikipagelibrarylist": "위키 페이지 라이브러리",
  "filetype_spwikipagelibrarylist": "위키 페이지 라이브러리",
  "spworkflowhistory": "워크플로 기록",
  "filetype_spworkflowhistory": "워크플로 기록",
  "spworkflowhistorylist": "워크플로 기록 목록",
  "filetype_spworkflowhistorylist": "워크플로 기록 목록",
  "spworkflowprocess": "사용자 지정 워크플로 프로세스",
  "filetype_spworkflowprocess": "사용자 지정 워크플로 프로세스",
  "spworkflowprocesslist": "사용자 지정 워크플로 프로세스",
  "filetype_spworkflowprocesslist": "사용자 지정 워크플로 프로세스",
  "sppublishingimageslibrarylist": "게시 이미지 라이브러리",
  "filetype_sppublishingimageslibrarylist": "게시 이미지 라이브러리",
  "spcirculation": "회람",
  "filetype_spcirculation": "회람",
  "spcirculationlist": "회람",
  "filetype_spcirculationlist": "회람",
  "spdashboardslibrarylist": "대시보드 라이브러리",
  "filetype_spdashboardslibrarylist": "대시보드 라이브러리",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 데이터 연결 라이브러리",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 데이터 연결 라이브러리",
  "sphealthreport": "상태 보고서",
  "filetype_sphealthreport": "상태 보고서",
  "sphealthreportlist": "상태 보고서",
  "filetype_sphealthreportlist": "상태 보고서",
  "sphealthrule": "상태 규칙",
  "filetype_sphealthrule": "상태 규칙",
  "sphealthrulelist": "상태 규칙",
  "filetype_sphealthrulelist": "상태 규칙",
  "spimedictionary": "IME 사전",
  "filetype_spimedictionary": "IME 사전",
  "spimedictionarylist": "IME 사전",
  "filetype_spimedictionarylist": "IME 사전",
  "spperformancepointcontent": "PerformancePoint 콘텐츠",
  "filetype_spperformancepointcontent": "PerformancePoint 콘텐츠",
  "spperformancepointcontentlist": "PerformancePoint 콘텐츠",
  "filetype_spperformancepointcontentlist": "PerformancePoint 콘텐츠",
  "spphonecallmemo": "부재 중 전화 메모",
  "filetype_spphonecallmemo": "부재 중 전화 메모",
  "spphonecallmemolist": "부재 중 전화 메모",
  "filetype_spphonecallmemolist": "부재 중 전화 메모",
  "sprecordlibrarylist": "레코드 라이브러리",
  "filetype_sprecordlibrarylist": "레코드 라이브러리",
  "spresource": "리소스",
  "filetype_spresource": "리소스",
  "spresourcelist": "리소스",
  "filetype_spresourcelist": "리소스",
  "spprocessdiagramslibrarylist": "프로세스 다이어그램 라이브러리",
  "filetype_spprocessdiagramslibrarylist": "프로세스 다이어그램 라이브러리",
  "spsitethemeslibrarylist": "사이트 테마 라이브러리",
  "filetype_spsitethemeslibrarylist": "사이트 테마 라이브러리",
  "spsolutionslibrarylist": "솔루션 라이브러리",
  "filetype_spsolutionslibrarylist": "솔루션 라이브러리",
  "spwfpublibrarylist": "WFPUB 라이브러리",
  "filetype_spwfpublibrarylist": "WFPUB 라이브러리",
  "spwhereabout": "소재",
  "filetype_spwhereabout": "소재",
  "spwhereaboutlist": "소재",
  "filetype_spwhereaboutlist": "소재",
  "spdocumentlink": "문서 링크",
  "filetype_spdocumentlink": "문서 링크",
  "spdocumentset": "문서 집합",
  "filetype_spdocumentset": "문서 집합",
  "spmicrofeedpost": "마이크로피드 게시물",
  "filetype_spmicrofeedpost": "마이크로피드 게시물",
  "spmicrofeedlist": "마이크로피드",
  "filetype_spmicrofeedlist": "마이크로피드",
  "splistfolder": "목록 폴더",
  "filetype_splistfolder": "목록 폴더",
  "Unknown": "알 수 없음",
  "And": "및",
  "Authenticating": "{0}을(를) 인증하는 중...",
  "Clear": "{0} 지우기",
  "CompleteQuery": "전체 쿼리",
  "Exclude": "{0} 제외",
  "EnterTag": "태그 추가",
  "Next": "다음",
  "Last": "마지막",
  "Link": "링크",
  "Or": "또는",
  "Previous": "이전",
  "QueryDidntMatchAnyDocuments": "쿼리가 어느 문서와도 일치하지 않습니다.",
  "QueryException": "쿼리에 오류가 있습니다: {0}.",
  "Me": "나",
  "Remove": "제거",
  "Search": "검색",
  "SearchFor": "{0} 검색",
  "ShareQuery": "쿼리 공유",
  "Preferences": "기본 설정",
  "LinkOpeningSettings": "링크 열기 설정",
  "Reauthenticate": "{0} 재인증",
  "ResultsFilteringExpression": "결과 필터링 표현",
  "FiltersInYourPreferences": "사용자의 기본 설정에서 필터",
  "Create": "만들기",
  "SearchIn": "{0}에서 검색",
  "Seconds": "{0} 초 후",
  "ShowingResultsOf": "결과 {0},{2} 중<pl>-{1}</pl>",
  "ShowingResultsOfWithQuery": "결과 {0},{2} 중<pl>-{1}</pl>",
  "SwitchTo": "{0}(으)로 전환",
  "Unexclude": "{0} 비제외",
  "ClearAllFilters": "모든 필터 지우기",
  "SkipLogin": "로그인 건너뛰기",
  "LoginInProgress": "로그인 진행 중, 기다려주십시오...",
  "Login": "로그인",
  "GetStarted": "시작하기",
  "More": "더 보기",
  "NMore": "{0}개 더…",
  "Less": "덜 보기",
  "Settings": "설정",
  "Score": "점수",
  "ScoreDescription": "점수는 결과 세트 내 위치에서뿐 아니라 빈도 수로부터도 계산됩니다.",
  "Occurrences": "빈도",
  "OccurrencesDescription": "가장 큰 수가 있는 값이 먼저 표시되게 빈도 수로 정렬",
  "Label": "라벨",
  "Of": "중",
  "LabelDescription": "필드 값 알파벳 순 정렬",
  "Value": "값",
  "ValueDescription": "최초 계산된 필드의 값으로 정렬",
  "AlphaAscending": "오름차순 값",
  "AlphaDescending": "내림차순 값",
  "ChiSquare": "카이 제곱",
  "Nosort": "정렬 항목 없음",
  "NosortDescription": "값을 정렬하지 않습니다. 값이 임의 순서대로 반환됩니다.",
  "RelativeFrequency": "상대 빈도",
  "RelativeFrequencyDescription": "값의 상대 빈도를 기준으로 정렬. 덜 흔한 값이 더 높은 위치에 표시됩니다.",
  "DateDistribution": "날짜 분포",
  "Custom": "사용자 정의",
  "CustomDescription": "사용자 정의 순서대로 정렬",
  "ComputedField": "계산된 필드",
  "Ascending": "오름차순",
  "Descending": "내림차순",
  "noResultFor": "{0}에 대한 검색 결과가 없습니다",
  "autoCorrectedQueryTo": "쿼리가 {0}(으)로 자동 교정됐습니다",
  "didYouMean": "다음을 뜻하셨나요: {0}",
  "SuggestedResults": "제안된 결과",
  "SuggestedQueries": "제안된 쿼리",
  "MostRelevantItems": "가장 관련 있는 항목:",
  "AllItems": "모든 항목:",
  "ShowLess": "최소 표시",
  "ShowMore": "최대 표시",
  "HideFacet": "패싯 감추기",
  "ShowFacet": "패싯 표시",
  "AndOthers": "및 기타 {0}",
  "Others": "기타 {0}",
  "MostRelevantPosts": "가장 관련 있는 게시글:",
  "CompleteThread": "전체 스레드:",
  "ShowCompleteThread": "전체 스레드 표시",
  "ShowOnlyTopMatchingPosts": "최대 일치 게시글만 표시",
  "MostRelevantReplies": "가장 관련 있는 댓글:",
  "AllConversation": "모든 대화:",
  "ShowAllConversation": "모든 대화 표시",
  "ShowAllReplies": "모든 댓글 표시",
  "ShowOnlyMostRelevantReplies": "가장 관련 있는 댓글만 표시",
  "Close": "닫기",
  "Open": "열기",
  "OpenInOutlookWhenPossible": "Outlook에서 열기(가능한 경우)",
  "AlwaysOpenInNewWindow": "결과를 항상 새 창에서 열기",
  "Quickview": "간략히 보기",
  "NoQuickview": "이 문서의 빨리 보기를 사용할 수 없습니다",
  "ErrorReport": "오류 보고",
  "OopsError": "서버에 이상이 생겼습니다.",
  "ProblemPersists": "문제가 계속되면 관리자에게 연락하십시오.",
  "GoBack": "뒤로",
  "Reset": "재설정",
  "Retry": "재시도",
  "MoreInfo": "추가 정보",
  "Username": "사용자 이름",
  "Password": "암호",
  "PostedBy": "게시자",
  "CannotConnect": "서버 주소에 연결할 수 없습니다.",
  "BadUserPass": "암호가 사용자 이름과 일치하지 않습니다.",
  "PleaseEnterYourCredentials": "{0}에 대한 자격 증명을 입력하십시오.",
  "PleaseEnterYourSearchPage": "검색 페이지 URL을 입력하십시오.",
  "Collapse": "축소",
  "Collapsable": "축소 가능",
  "Expand": "확대",
  "Today": "오늘",
  "Yesterday": "어제",
  "Tomorrow": "내일",
  "Duration": "표시 시간: {0}",
  "IndexDuration": "색인 표시 시간: {0}",
  "ProxyDuration": "프록시 표시 시간: {0}",
  "ClientDuration": "클라이언트 표시 시간: {0}",
  "Unavailable": "없음",
  "Reply": "회신",
  "ReplyAll": "모두에게 회신",
  "Forward": "전달",
  "From": "보낸 사람",
  "Caption": "제목",
  "Expression": "표현식",
  "Tab": "탭",
  "Tabs": "탭들",
  "EnterExpressionName": "표현식 이름 입력",
  "EnterExpressionToFilterWith": "다음 결과를 필터할 표현식 입력",
  "SelectTab": "탭 선택",
  "SelectAll": "모두 선택",
  "PageUrl": "검색 페이지 URL",
  "ErrorSavingToDevice": "정보를 사용자의 기기에 저장하는 중 오류",
  "ErrorReadingFromDevice": "정보를 사용자의 기기에서 읽는 중 오류",
  "AppIntro": "Coveo에 관한 질문에 답하고 Coveo 솔루션이 사용자에게 적합한지 알아보는 데 도움을 줄 수 있는 제품 전문가와 상담하십시오. 또는 실제 시연을 이용하십시오!",
  "TryDemo": "시연 이용",
  "ContactUs": "연락처",
  "NewToCoveo": "Coveo가 처음이신가요?",
  "LetUsHelpGetStarted": "저희가 시작을 돕겠습니다",
  "LikesThis": "{0}(이)가 이것을 좋아합니다.",
  "CannotConnectSearchPage": "검색 페이지에 연결할 수 없습니다",
  "AreYouSureDeleteFilter": "{1} 식이 있는 필터 {0}(을)를 삭제하시겠습니까?",
  "OnlineHelp": "온라인 도움말",
  "Done": "완료",
  "SaveFacetState": "이 패싯 상태를 저장",
  "ClearFacetState": "패싯 상태 지우기",
  "DisplayingTheOnlyMessage": "이 대화에서 유일한 메시지를 표시",
  "NoNetworkConnection": "네트워크에 연결할 수 없습니다",
  "UnknownConnection": "알 수 없는 연결",
  "EthernetConnection": "이더넷 연결",
  "WiFi": "WiFi 연결",
  "CELL": "휴대 전화 연결",
  "CELL_2G": "휴대 전화 2G 연결",
  "CELL_3G": "휴대 전화 3G 연결",
  "CELL_4G": "휴대 전화 4G 연결",
  "Relevance": "관련성",
  "Date": "날짜",
  "Amount": "금액",
  "QueryExceptionNoException": "예외가 없습니다",
  "QueryExceptionInvalidSyntax": "구문이 잘못되었습니다",
  "QueryExceptionInvalidCustomField": "사용자 정의 필드가 잘못되었습니다",
  "QueryExceptionInvalidDate": "날짜가 잘못되었습니다",
  "QueryExceptionInvalidExactPhrase": "일치하여야 하는 구가 잘못되었습니다",
  "QueryExceptionInvalidDateOp": "날짜 연산자가 잘못되었습니다",
  "QueryExceptionInvalidNear": "NEAR 연산자가 잘못되었습니다",
  "QueryExceptionInvalidWeightedNear": "가중 NEAR 연산자가 잘못되었습니다",
  "QueryExceptionInvalidTerm": "용어가 잘못되었습니다",
  "QueryExceptionTooManyTerms": "용어가 너무 많습니다",
  "QueryExceptionWildcardTooGeneral": "와일드카드가 너무 일반적입니다",
  "QueryExceptionInvalidSortField": "정렬 필드가 잘못되었습니다",
  "QueryExceptionInvalidSmallStringOp": "단문자열 연산자가 잘못되었습니다",
  "QueryExceptionRequestedResultsMax": "요청 결과 최대 한도",
  "QueryExceptionAggregatedMirrorDead": "집합 미러가 오프라인입니다",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "집합 미러 쿼리 시간 제한",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "집합 미러의 잘못된 빌드 번호",
  "QueryExceptionAggregatedMirrorCannotConnect": "집합 미러를 연결할 수 없습니다",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "선행 문자 와일드카드가 충분하지 않습니다",
  "QueryExceptionSecurityInverterNotFound": "보안 인버터를 찾을 수 없습니다",
  "QueryExceptionSecurityInverterAccessDenied": "보안 인버터 접근이 거부됐습니다",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "집합 미러를 가장할 수 없습니다",
  "QueryExceptionUnexpected": "예상하지 않은",
  "QueryExceptionAccessDenied": "접근이 거부됐습니다",
  "QueryExceptionSuperUserTokenInvalid": "슈퍼 유저 토큰이 잘못되었습니다",
  "QueryExceptionSuperUserTokenExpired": "슈퍼 유저 토큰이 만료됐습니다",
  "QueryExceptionLicenseQueriesExpired": "쿼리 라이선스가 만료됐습니다",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "지원하지 않는 라이선스 슈퍼 유저 토큰입니다",
  "QueryExceptionInvalidSession": "세션이 잘못됐습니다",
  "QueryExceptionInvalidDocument": "문서가 잘못됐습니다",
  "QueryExceptionSearchDisabled": "검색 사용 안 함",
  "FileType": "파일 형식",
  "ShowAttachment": "첨부 표시",
  "OnFeed": "{0}의 피드.",
  "Author": "작성자",
  "NoTitle": "제목 없음",
  "CurrentSelections": "현재 선택",
  "AllContent": "모든 콘텐츠",
  "CancelLastAction": "마지막 실행 취소",
  "SearchTips": "검색 요령",
  "CheckSpelling": "핵심어의 철자를 확인합니다.",
  "TryUsingFewerKeywords": "키워드를 더 적게 또는 다양하게 사용하거나 더 일반적인 키워드를 사용해봅니다",
  "SelectFewerFilters": "필터를 줄여 검색 범위를 넓힙니다.",
  "Document": "문서",
  "Time": "시간",
  "StartDate": "시작 날짜",
  "StartTime": "시작 시간",
  "DurationTitle": "표시 시간",
  "UserQuery": "사용자 쿼리",
  "ShowUserActions": "사용자 작업 보이기",
  "NoData": "데이터가 없습니다",
  "EventType": "이벤트 유형",
  "GoToFullSearch": "전체 검색",
  "GoToEdition": "패널 사용자 지정",
  "RemoveContext": "컨텍스트 제거",
  "BoxAttachToCase": "요청에 연결",
  "AttachToCase": "요청에 연결",
  "Attach": "연결",
  "Attached": "연결됨",
  "Detach": "분리",
  "Details": "세부 정보",
  "AdditionalFilters": "추가 필터",
  "SelectNonContextualSearch": "검색 범위를 넓히려면 현재 레코드에서 컨텍스트를 제거하십시오",
  "CopyPasteToSupport": "자세한 정보를 원하시면 이 메시지를 복사하고 붙여 넣어 Coveo 지원팀에 보내십시오.",
  "FollowQueryDescription": "이 쿼리의 검색 결과에 대한 변경 내용을 내게 알려줍니다.",
  "SearchAlerts_Panel": "알림 관리",
  "SearchAlerts_PanelDescription": "사용자의 검색 알림을 보고 관리합니다.",
  "SearchAlerts_PanelNoSearchAlerts": "구독이 없습니다.",
  "SearchAlerts_Fail": "검색 알림 서비스를 현재 사용할 수 없습니다.",
  "SearchAlerts_Type": "유형",
  "SearchAlerts_Content": "내용",
  "SearchAlerts_Actions": "작업",
  "EmptyQuery": "<비어 있음>",
  "SearchAlerts_Type_followQuery": "쿼리",
  "SearchAlerts_Type_followDocument": "항목",
  "SearchAlerts_unFollowing": "팔로잉 중지",
  "SearchAlerts_follow": "팔로우",
  "SearchAlerts_followed": "팔로우함",
  "SearchAlerts_followQuery": "쿼리 팔로우",
  "Subscription_StopFollowingQuery": "쿼리 팔로잉 중지",
  "SearchAlerts_Frequency": "언제",
  "SubscriptionsManageSubscriptions": "알림 관리",
  "SubscriptionsMessageFollowQuery": "쿼리 <b>{0}</b>(이)가 새 항목이나 업데이트된 항목을 반환할 때 알림을 받습니다.",
  "SubscriptionsMessageFollow": "항목 <b>{0}</b>의 변경 내용에 대한 알림을 받습니다.",
  "Expiration": "만료",
  "Monthly": "매월",
  "Daily": "매일",
  "Monday": "월요일",
  "Tuesday": "화요일",
  "Wednesday": "수요일",
  "Thursday": "목요일",
  "Friday": "금요일",
  "Saturday": "토요일",
  "Sunday": "일요일",
  "NextDay": "다음 {0}",
  "LastDay": "지난 {0}",
  "StartTypingCaseForSuggestions": "가능한 솔루션을 보려면 문제를 설명하십시오",
  "ExportToExcel": "엑셀로 내부내기",
  "ExportToExcelDescription": "검색 결과를 엑셀로 내보내기",
  "CaseCreationNoResults": "권장 솔루션이 없습니다",
  "SortBy": "정렬 기준",
  "BoxCreateArticle": "문서 만들기",
  "Facets": "패싯",
  "AdvancedSearch": "고급 검색",
  "Keywords": "키워드",
  "AllTheseWords": "이 모든 단어",
  "ExactPhrase": "이와 똑같은 어구",
  "AnyOfTheseWords": "이 단어 중 어느 것이든",
  "NoneOfTheseWords": "이 단어 중 아무것도 없음",
  "Anytime": "항상",
  "InTheLast": "최근",
  "Days": "일",
  "Months": "개월",
  "Month": "월",
  "Year": "연",
  "Between": "사이",
  "Language": "언어",
  "Size": "크기",
  "AtLeast": "최소",
  "AtMost": "최대",
  "Contains": "포함",
  "DoesNotContain": "(이)가 없습니다",
  "Matches": "일치",
  "Bytes": "바이트",
  "card": "카드",
  "table": "표",
  "ResultLinks": "결과 링크",
  "EnableQuerySyntax": "쿼리 구문 사용",
  "On": "켬",
  "Off": "끔",
  "Automatic": "자동",
  "ResultsPerPage": "페이지당 결과 표시",
  "PreviousMonth": "이전 달",
  "NextMonth": "다음 달",
  "Title": "제목",
}
  var locales = String["locales"] || (String["locales"] = {});
  locales["ko"] = merge(locales["ko"], dict);
  String["toLocaleString"].call(this, { "ko": dict });
  String["locale"] = "ko";
  String["defaultLocale"] = "en";
  Globalize.culture("ko")})();
if(!window.Coveo){window.Coveo = {};}
Coveo.setLanguageAfterPageLoaded = function() {
var merge = function(obj1, obj2) {
  var obj3 = {};
  for(var attrname in obj1){obj3[attrname] = obj1[attrname]; }
  for(var attrname in obj2){obj3[attrname] = obj2[attrname]; }
  return obj3;
}

var dict = {
  "box user": "사용자",
  "filetype_box user": "사용자",
  "html": "HTML 파일",
  "filetype_html": "HTML 파일",
  "wiki": "위키",
  "filetype_wiki": "위키",
  "webscraperwebpage": "웹 페이지",
  "filetype_webscraperwebpage": "웹 페이지",
  "image": "이미지",
  "filetype_image": "이미지",
  "folder": "폴더",
  "filetype_folder": "폴더",
  "txt": "텍스트",
  "filetype_txt": "텍스트",
  "zip": "Zip 파일",
  "filetype_zip": "Zip 파일",
  "olefile": "OLE 파일",
  "filetype_olefile": "OLE 파일",
  "gmailmessage": "Gmail 메시지",
  "filetype_gmailmessage": "Gmail 메시지",
  "pdf": "PDF 파일",
  "filetype_pdf": "PDF 파일",
  "swf": "플래시 파일",
  "filetype_swf": "플래시 파일",
  "xml": "XML 파일",
  "filetype_xml": "XML 파일",
  "vsd": "Visio",
  "filetype_vsd": "Visio",
  "svg": "SVG",
  "filetype_svg": "SVG",
  "svm": "Open Office",
  "filetype_svm": "Open Office",
  "rssitem": "RSS 피드",
  "filetype_rssitem": "RSS 피드",
  "doc": "문서",
  "filetype_doc": "문서",
  "docx": "마이크로소프트 워드 문서",
  "filetype_docx": "마이크로소프트 워드 문서",
  "xls": "스프레드시트 문서",
  "filetype_xls": "스프레드시트 문서",
  "ppt": "프레젠테이션 문서",
  "filetype_ppt": "프레젠테이션 문서",
  "video": "동영상",
  "filetype_video": "동영상",
  "saleforceitem": "세일즈포스",
  "filetype_saleforceitem": "세일즈포스",
  "dynamicscrmitem": "Dynamics CRM",
  "filetype_dynamicscrmitem": "Dynamics CRM",
  "salesforceitem": "세일즈포스",
  "filetype_salesforceitem": "세일즈포스",
  "odt": "오픈 텍스트 문서",
  "filetype_odt": "오픈 텍스트 문서",
  "lithiummessage": "Lithium 메시지",
  "filetype_lithiummessage": "Lithium 메시지",
  "lithiumthread": "Lithium 스레드",
  "filetype_lithiumthread": "Lithium 스레드",
  "lithiumboard": "Lithium 게시판",
  "filetype_lithiumboard": "Lithium 게시판",
  "lithiumcategory": "Lithium 카테고리",
  "filetype_lithiumcategory": "Lithium 카테고리",
  "lithiumcommunity": "Lithium 커뮤니티",
  "filetype_lithiumcommunity": "Lithium 커뮤니티",
  "people": "사용자",
  "objecttype_people": "사용자",
  "message": "메시지",
  "objecttype_message": "메시지",
  "feed": "RSS 피드",
  "objecttype_feed": "RSS 피드",
  "thread": "스레드",
  "objecttype_thread": "스레드",
  "file": "파일",
  "objecttype_file": "파일",
  "board": "게시판",
  "objecttype_board": "게시판",
  "category": "카테고리",
  "objecttype_category": "카테고리",
  "account": "계정",
  "objecttype_account": "계정",
  "annotation": "메모",
  "objecttype_annotation": "메모",
  "campaign": "캠페인",
  "objecttype_campaign": "캠페인",
  "case": "사례",
  "objecttype_case": "사례",
  "contact": "연락처",
  "objecttype_contact": "연락처",
  "contract": "계약",
  "objecttype_contract": "계약",
  "event": "이벤트",
  "objecttype_event": "이벤트",
  "email": "이메일",
  "objecttype_email": "이메일",
  "goal": "목표",
  "objecttype_goal": "목표",
  "incident": "사건",
  "objecttype_incident": "사건",
  "invoice": "인보이스",
  "objecttype_invoice": "인보이스",
  "lead": "잠재 고객",
  "objecttype_lead": "잠재 고객",
  "list": "목록",
  "objecttype_list": "마케팅 목록",
  "solution": "솔루션",
  "objecttype_solution": "솔루션",
  "task": "작업",
  "objecttype_task": "작업",
  "user": "사용자",
  "objecttype_user": "사용자",
  "attachment": "첨부 파일",
  "objecttype_attachment": "첨부 파일",
  "casecomment": "사례 메모",
  "objecttype_casecomment": "사례 메모",
  "opportunity": "기회",
  "objecttype_opportunity": "기회",
  "opportunityproduct": "영업 기회 제품",
  "objecttype_opportunityproduct": "영업 기회 제품",
  "feeditem": "채터",
  "objecttype_feeditem": "채터",
  "feedcomment": "채터",
  "objecttype_feedcomment": "채터",
  "note": "메모",
  "objecttype_note": "메모",
  "product": "제품",
  "objecttype_product": "제품",
  "partner": "파트너",
  "objecttype_partner": "파트너",
  "queueitem": "큐 항목",
  "objecttype_queueitem": "큐 항목",
  "quote": "견적",
  "objecttype_quote": "견적",
  "salesliterature": "영업 홍보 자료",
  "objecttype_salesliterature": "영업 홍보 자료",
  "salesorder": "판매 주문",
  "objecttype_salesorder": "판매 주문",
  "service": "서비스",
  "objecttype_service": "서비스",
  "socialprofile": "소셜 프로필",
  "objecttype_socialprofile": "소셜 프로필",
  "kbdocumentation": "문서",
  "objecttype_kbdocumentation": "문서",
  "kbtechnicalarticle": "문서",
  "objecttype_kbtechnicalarticle": "문서",
  "kbsolution": "솔루션",
  "objecttype_kbsolution": "솔루션",
  "kbknowledgearticle": "참조 문서",
  "objecttype_kbknowledgearticle": "참조 문서",
  "kbattachment": "첨부 파일",
  "objecttype_kbattachment": "첨부 파일",
  "kbarticle": "문서",
  "objecttype_kbarticle": "문서",
  "kbarticlecomment": "문서 주석",
  "objecttype_kbarticlecomment": "문서 주석",
  "knowledgearticle": "참조 문서",
  "objecttype_knowledgearticle": "참조 문서",
  "topic": "주제",
  "objecttype_topic": "주제",
  "dashboard": "대시보드",
  "objecttype_dashboard": "대시보드",
  "contentversion": "문서",
  "objecttype_contentversion": "문서",
  "collaborationgroup": "공동 작업 그룹",
  "objecttype_collaborationgroup": "공동 작업 그룹",
  "spportal": "포털",
  "filetype_spportal": "포털",
  "spsite": "사이트",
  "filetype_spsite": "사이트",
  "spuserprofile": "SharePoint 사용자",
  "filetype_spuserprofile": "SharePoint 사용자",
  "sparea": "영역",
  "filetype_sparea": "영역",
  "spannouncement": "공지 사항",
  "filetype_spannouncement": "공지 사항",
  "spannouncementlist": "공지 사항",
  "filetype_spannouncementlist": "공지 사항",
  "spcontact": "연락처",
  "filetype_spcontact": "연락처",
  "spcontactlist": "연락처",
  "filetype_spcontactlist": "연락처",
  "spcustomlist": "사용자 지정 목록",
  "filetype_spcustomlist": "사용자 지정 목록",
  "spdiscussionboard": "토론 게시판",
  "filetype_spdiscussionboard": "토론 게시판",
  "spdiscussionboardlist": "토론 게시판",
  "filetype_spdiscussionboardlist": "토론 게시판",
  "spdocumentlibrarylist": "문서 라이브러리",
  "filetype_spdocumentlibrarylist": "문서 라이브러리",
  "spevent": "이벤트",
  "filetype_spevent": "이벤트",
  "speventlist": "이벤트",
  "filetype_speventlist": "이벤트",
  "spformlibrarylist": "양식 라이브러리",
  "filetype_spformlibrarylist": "양식 라이브러리",
  "spissue": "문제",
  "filetype_spissue": "문제",
  "spissuelist": "문제",
  "filetype_spissuelist": "문제",
  "splink": "링크",
  "filetype_splink": "링크",
  "splinklist": "링크",
  "filetype_splinklist": "링크",
  "sppicturelibrarylist": "그림 라이브러리",
  "filetype_sppicturelibrarylist": "그림 라이브러리",
  "spsurvey": "설문 조사",
  "filetype_spsurvey": "설문 조사",
  "spsurveylist": "설문 조사",
  "filetype_spsurveylist": "설문 조사",
  "sptask": "작업",
  "filetype_sptask": "작업",
  "sptasklist": "작업",
  "filetype_sptasklist": "작업",
  "spagenda": "회의록",
  "filetype_spagenda": "회의록",
  "spagendalist": "회의록",
  "filetype_spagendalist": "회의록",
  "spattendee": "참석자",
  "filetype_spattendee": "참석자",
  "spattendeelist": "참석자",
  "filetype_spattendeelist": "참석자",
  "spcustomgridlist": "사용자 지정 눈금",
  "filetype_spcustomgridlist": "사용자 지정 눈금",
  "spdecision": "결정 사항",
  "filetype_spdecision": "결정 사항",
  "spdecisionlist": "결정 사항",
  "filetype_spdecisionlist": "결정 사항",
  "spobjective": "목표",
  "filetype_spobjective": "목표",
  "spobjectivelist": "목표",
  "filetype_spobjectivelist": "목표",
  "sptextbox": "텍스트 상자",
  "filetype_sptextbox": "텍스트 상자",
  "sptextboxlist": "텍스트 상자 목록",
  "filetype_sptextboxlist": "텍스트 상자 목록",
  "spthingstobring": "필요한 것",
  "filetype_spthingstobring": "필요한 것",
  "spthingstobringlist": "필요한 것",
  "filetype_spthingstobringlist": "필요한 것",
  "sparealisting": "영역 목록",
  "filetype_sparealisting": "영역 목록",
  "spmeetingserie": "모임 되풀이 항목",
  "filetype_spmeetingserie": "모임 되풀이 항목",
  "spmeetingserielist": "모임 되풀이 항목 목록",
  "filetype_spmeetingserielist": "모임 되풀이 항목 목록",
  "spsitedirectory": "사이트 디렉터리 항목",
  "filetype_spsitedirectory": "사이트 디렉터리 항목",
  "spsitedirectorylist": "사이트 디렉터리",
  "filetype_spsitedirectorylist": "사이트 디렉터리",
  "spdatasource": "데이터 원본",
  "filetype_spdatasource": "데이터 원본",
  "spdatasourcelist": "데이터 원본 목록",
  "filetype_spdatasourcelist": "데이터 원본 목록",
  "splisttemplatecataloglist": "목록 서식 파일 갤러리",
  "filetype_splisttemplatecataloglist": "목록 서식 파일 갤러리",
  "spwebpartcataloglist": "웹 파트 갤러리",
  "filetype_spwebpartcataloglist": "웹 파트 갤러리",
  "spwebtemplatecataloglist": "사이트 서식 파일 갤러리",
  "filetype_spwebtemplatecataloglist": "사이트 서식 파일 갤러리",
  "spworkspacepagelist": "작업 영역 페이지",
  "filetype_spworkspacepagelist": "작업 영역 페이지",
  "spunknownlist": "사용자 지정 목록",
  "filetype_spunknownlist": "사용자 지정 목록",
  "spadministratortask": "관리자 작업",
  "filetype_spadministratortask": "관리자 작업",
  "spadministratortasklist": "관리자 작업",
  "filetype_spadministratortasklist": "관리자 작업",
  "spareadocumentlibrarylist": "영역 문서 라이브러리",
  "filetype_spareadocumentlibrarylist": "영역 문서 라이브러리",
  "spblogcategory": "블로그 카테고리",
  "filetype_spblogcategory": "블로그 카테고리",
  "spblogcategorylist": "블로그 카테고리",
  "filetype_spblogcategorylist": "블로그 카테고리",
  "spblogcomment": "블로그 메모",
  "filetype_spblogcomment": "블로그 메모",
  "spblogcommentlist": "블로그 메모",
  "filetype_spblogcommentlist": "블로그 메모",
  "spblogpost": "블로그 게시물",
  "filetype_spblogpost": "블로그 게시물",
  "spblogpostlist": "블로그 게시물",
  "filetype_spblogpostlist": "블로그 게시물",
  "spdataconnectionlibrarylist": "데이터 연결 라이브러리",
  "filetype_spdataconnectionlibrarylist": "데이터 연결 라이브러리",
  "spdistributiongroup": "메일 그룹",
  "filetype_spdistributiongroup": "메일 그룹",
  "spdistributiongrouplist": "메일 그룹",
  "filetype_spdistributiongrouplist": "메일 그룹",
  "spipfslist": "InfoPath 양식 서버",
  "filetype_spipfslist": "InfoPath 양식 서버",
  "spkeyperformanceindicator": "핵심 성과 지표",
  "filetype_spkeyperformanceindicator": "핵심 성과 지표",
  "spkeyperformanceindicatorlist": "핵심 성과 지표",
  "filetype_spkeyperformanceindicatorlist": "핵심 성과 지표",
  "splanguagesandtranslator": "언어와 번역기",
  "filetype_splanguagesandtranslator": "언어와 번역기",
  "splanguagesandtranslatorlist": "언어와 번역기",
  "filetype_splanguagesandtranslatorlist": "언어와 번역기",
  "spmasterpagescataloglist": "마스터 페이지 갤러리",
  "filetype_spmasterpagescataloglist": "마스터 페이지 갤러리",
  "spnocodeworkflowlibrarylist": "코드 없는 워크플로 라이브러리",
  "filetype_spnocodeworkflowlibrarylist": "코드 없는 워크플로 라이브러리",
  "spprojecttask": "프로젝트 작업",
  "filetype_spprojecttask": "프로젝트 작업",
  "spprojecttasklist": "프로젝트 작업",
  "filetype_spprojecttasklist": "프로젝트 작업",
  "sppublishingpageslibrarylist": "페이지 라이브러리",
  "filetype_sppublishingpageslibrarylist": "페이지 라이브러리",
  "spreportdocumentlibrarylist": "보고서 문서 라이브러리",
  "filetype_spreportdocumentlibrarylist": "보고서 문서 라이브러리",
  "spreportlibrarylist": "보고서 라이브러리",
  "filetype_spreportlibrarylist": "보고서 라이브러리",
  "spslidelibrarylist": "슬라이드 라이브러리",
  "filetype_spslidelibrarylist": "슬라이드 라이브러리",
  "sptab": "탭",
  "filetype_sptab": "탭",
  "sptablist": "탭 목록",
  "filetype_sptablist": "탭 목록",
  "sptranslationmanagementlibrarylist": "번역 관리 라이브러리",
  "filetype_sptranslationmanagementlibrarylist": "번역 관리 라이브러리",
  "spuserinformation": "사용자 정보",
  "filetype_spuserinformation": "사용자 정보",
  "spuserinformationlist": "사용자 정보 목록",
  "filetype_spuserinformationlist": "사용자 정보 목록",
  "spwikipagelibrarylist": "위키 페이지 라이브러리",
  "filetype_spwikipagelibrarylist": "위키 페이지 라이브러리",
  "spworkflowhistory": "워크플로 기록",
  "filetype_spworkflowhistory": "워크플로 기록",
  "spworkflowhistorylist": "워크플로 기록 목록",
  "filetype_spworkflowhistorylist": "워크플로 기록 목록",
  "spworkflowprocess": "사용자 지정 워크플로 프로세스",
  "filetype_spworkflowprocess": "사용자 지정 워크플로 프로세스",
  "spworkflowprocesslist": "사용자 지정 워크플로 프로세스",
  "filetype_spworkflowprocesslist": "사용자 지정 워크플로 프로세스",
  "sppublishingimageslibrarylist": "게시 이미지 라이브러리",
  "filetype_sppublishingimageslibrarylist": "게시 이미지 라이브러리",
  "spcirculation": "회람",
  "filetype_spcirculation": "회람",
  "spcirculationlist": "회람",
  "filetype_spcirculationlist": "회람",
  "spdashboardslibrarylist": "대시보드 라이브러리",
  "filetype_spdashboardslibrarylist": "대시보드 라이브러리",
  "spdataconnectionforperformancepointlibrarylist": "PerformancePoint 데이터 연결 라이브러리",
  "filetype_spdataconnectionforperformancepointlibrarylist": "PerformancePoint 데이터 연결 라이브러리",
  "sphealthreport": "상태 보고서",
  "filetype_sphealthreport": "상태 보고서",
  "sphealthreportlist": "상태 보고서",
  "filetype_sphealthreportlist": "상태 보고서",
  "sphealthrule": "상태 규칙",
  "filetype_sphealthrule": "상태 규칙",
  "sphealthrulelist": "상태 규칙",
  "filetype_sphealthrulelist": "상태 규칙",
  "spimedictionary": "IME 사전",
  "filetype_spimedictionary": "IME 사전",
  "spimedictionarylist": "IME 사전",
  "filetype_spimedictionarylist": "IME 사전",
  "spperformancepointcontent": "PerformancePoint 콘텐츠",
  "filetype_spperformancepointcontent": "PerformancePoint 콘텐츠",
  "spperformancepointcontentlist": "PerformancePoint 콘텐츠",
  "filetype_spperformancepointcontentlist": "PerformancePoint 콘텐츠",
  "spphonecallmemo": "부재 중 전화 메모",
  "filetype_spphonecallmemo": "부재 중 전화 메모",
  "spphonecallmemolist": "부재 중 전화 메모",
  "filetype_spphonecallmemolist": "부재 중 전화 메모",
  "sprecordlibrarylist": "레코드 라이브러리",
  "filetype_sprecordlibrarylist": "레코드 라이브러리",
  "spresource": "리소스",
  "filetype_spresource": "리소스",
  "spresourcelist": "리소스",
  "filetype_spresourcelist": "리소스",
  "spprocessdiagramslibrarylist": "프로세스 다이어그램 라이브러리",
  "filetype_spprocessdiagramslibrarylist": "프로세스 다이어그램 라이브러리",
  "spsitethemeslibrarylist": "사이트 테마 라이브러리",
  "filetype_spsitethemeslibrarylist": "사이트 테마 라이브러리",
  "spsolutionslibrarylist": "솔루션 라이브러리",
  "filetype_spsolutionslibrarylist": "솔루션 라이브러리",
  "spwfpublibrarylist": "WFPUB 라이브러리",
  "filetype_spwfpublibrarylist": "WFPUB 라이브러리",
  "spwhereabout": "소재",
  "filetype_spwhereabout": "소재",
  "spwhereaboutlist": "소재",
  "filetype_spwhereaboutlist": "소재",
  "spdocumentlink": "문서 링크",
  "filetype_spdocumentlink": "문서 링크",
  "spdocumentset": "문서 집합",
  "filetype_spdocumentset": "문서 집합",
  "spmicrofeedpost": "마이크로피드 게시물",
  "filetype_spmicrofeedpost": "마이크로피드 게시물",
  "spmicrofeedlist": "마이크로피드",
  "filetype_spmicrofeedlist": "마이크로피드",
  "splistfolder": "목록 폴더",
  "filetype_splistfolder": "목록 폴더",
  "Unknown": "알 수 없음",
  "And": "및",
  "Authenticating": "{0}을(를) 인증하는 중...",
  "Clear": "{0} 지우기",
  "CompleteQuery": "전체 쿼리",
  "Exclude": "{0} 제외",
  "EnterTag": "태그 추가",
  "Next": "다음",
  "Last": "마지막",
  "Link": "링크",
  "Or": "또는",
  "Previous": "이전",
  "QueryDidntMatchAnyDocuments": "쿼리가 어느 문서와도 일치하지 않습니다.",
  "QueryException": "쿼리에 오류가 있습니다: {0}.",
  "Me": "나",
  "Remove": "제거",
  "Search": "검색",
  "SearchFor": "{0} 검색",
  "ShareQuery": "쿼리 공유",
  "Preferences": "기본 설정",
  "LinkOpeningSettings": "링크 열기 설정",
  "Reauthenticate": "{0} 재인증",
  "ResultsFilteringExpression": "결과 필터링 표현",
  "FiltersInYourPreferences": "사용자의 기본 설정에서 필터",
  "Create": "만들기",
  "SearchIn": "{0}에서 검색",
  "Seconds": "{0} 초 후",
  "ShowingResultsOf": "결과 {0},{2} 중<pl>-{1}</pl>",
  "ShowingResultsOfWithQuery": "결과 {0},{2} 중<pl>-{1}</pl>",
  "SwitchTo": "{0}(으)로 전환",
  "Unexclude": "{0} 비제외",
  "ClearAllFilters": "모든 필터 지우기",
  "SkipLogin": "로그인 건너뛰기",
  "LoginInProgress": "로그인 진행 중, 기다려주십시오...",
  "Login": "로그인",
  "GetStarted": "시작하기",
  "More": "더 보기",
  "NMore": "{0}개 더…",
  "Less": "덜 보기",
  "Settings": "설정",
  "Score": "점수",
  "ScoreDescription": "점수는 결과 세트 내 위치에서뿐 아니라 빈도 수로부터도 계산됩니다.",
  "Occurrences": "빈도",
  "OccurrencesDescription": "가장 큰 수가 있는 값이 먼저 표시되게 빈도 수로 정렬",
  "Label": "라벨",
  "Of": "중",
  "LabelDescription": "필드 값 알파벳 순 정렬",
  "Value": "값",
  "ValueDescription": "최초 계산된 필드의 값으로 정렬",
  "AlphaAscending": "오름차순 값",
  "AlphaDescending": "내림차순 값",
  "ChiSquare": "카이 제곱",
  "Nosort": "정렬 항목 없음",
  "NosortDescription": "값을 정렬하지 않습니다. 값이 임의 순서대로 반환됩니다.",
  "RelativeFrequency": "상대 빈도",
  "RelativeFrequencyDescription": "값의 상대 빈도를 기준으로 정렬. 덜 흔한 값이 더 높은 위치에 표시됩니다.",
  "DateDistribution": "날짜 분포",
  "Custom": "사용자 정의",
  "CustomDescription": "사용자 정의 순서대로 정렬",
  "ComputedField": "계산된 필드",
  "Ascending": "오름차순",
  "Descending": "내림차순",
  "noResultFor": "{0}에 대한 검색 결과가 없습니다",
  "autoCorrectedQueryTo": "쿼리가 {0}(으)로 자동 교정됐습니다",
  "didYouMean": "다음을 뜻하셨나요: {0}",
  "SuggestedResults": "제안된 결과",
  "SuggestedQueries": "제안된 쿼리",
  "MostRelevantItems": "가장 관련 있는 항목:",
  "AllItems": "모든 항목:",
  "ShowLess": "최소 표시",
  "ShowMore": "최대 표시",
  "HideFacet": "패싯 감추기",
  "ShowFacet": "패싯 표시",
  "AndOthers": "및 기타 {0}",
  "Others": "기타 {0}",
  "MostRelevantPosts": "가장 관련 있는 게시글:",
  "CompleteThread": "전체 스레드:",
  "ShowCompleteThread": "전체 스레드 표시",
  "ShowOnlyTopMatchingPosts": "최대 일치 게시글만 표시",
  "MostRelevantReplies": "가장 관련 있는 댓글:",
  "AllConversation": "모든 대화:",
  "ShowAllConversation": "모든 대화 표시",
  "ShowAllReplies": "모든 댓글 표시",
  "ShowOnlyMostRelevantReplies": "가장 관련 있는 댓글만 표시",
  "Close": "닫기",
  "Open": "열기",
  "OpenInOutlookWhenPossible": "Outlook에서 열기(가능한 경우)",
  "AlwaysOpenInNewWindow": "결과를 항상 새 창에서 열기",
  "Quickview": "간략히 보기",
  "NoQuickview": "이 문서의 빨리 보기를 사용할 수 없습니다",
  "ErrorReport": "오류 보고",
  "OopsError": "서버에 이상이 생겼습니다.",
  "ProblemPersists": "문제가 계속되면 관리자에게 연락하십시오.",
  "GoBack": "뒤로",
  "Reset": "재설정",
  "Retry": "재시도",
  "MoreInfo": "추가 정보",
  "Username": "사용자 이름",
  "Password": "암호",
  "PostedBy": "게시자",
  "CannotConnect": "서버 주소에 연결할 수 없습니다.",
  "BadUserPass": "암호가 사용자 이름과 일치하지 않습니다.",
  "PleaseEnterYourCredentials": "{0}에 대한 자격 증명을 입력하십시오.",
  "PleaseEnterYourSearchPage": "검색 페이지 URL을 입력하십시오.",
  "Collapse": "축소",
  "Collapsable": "축소 가능",
  "Expand": "확대",
  "Today": "오늘",
  "Yesterday": "어제",
  "Tomorrow": "내일",
  "Duration": "표시 시간: {0}",
  "IndexDuration": "색인 표시 시간: {0}",
  "ProxyDuration": "프록시 표시 시간: {0}",
  "ClientDuration": "클라이언트 표시 시간: {0}",
  "Unavailable": "없음",
  "Reply": "회신",
  "ReplyAll": "모두에게 회신",
  "Forward": "전달",
  "From": "보낸 사람",
  "Caption": "제목",
  "Expression": "표현식",
  "Tab": "탭",
  "Tabs": "탭들",
  "EnterExpressionName": "표현식 이름 입력",
  "EnterExpressionToFilterWith": "다음 결과를 필터할 표현식 입력",
  "SelectTab": "탭 선택",
  "SelectAll": "모두 선택",
  "PageUrl": "검색 페이지 URL",
  "ErrorSavingToDevice": "정보를 사용자의 기기에 저장하는 중 오류",
  "ErrorReadingFromDevice": "정보를 사용자의 기기에서 읽는 중 오류",
  "AppIntro": "Coveo에 관한 질문에 답하고 Coveo 솔루션이 사용자에게 적합한지 알아보는 데 도움을 줄 수 있는 제품 전문가와 상담하십시오. 또는 실제 시연을 이용하십시오!",
  "TryDemo": "시연 이용",
  "ContactUs": "연락처",
  "NewToCoveo": "Coveo가 처음이신가요?",
  "LetUsHelpGetStarted": "저희가 시작을 돕겠습니다",
  "LikesThis": "{0}(이)가 이것을 좋아합니다.",
  "CannotConnectSearchPage": "검색 페이지에 연결할 수 없습니다",
  "AreYouSureDeleteFilter": "{1} 식이 있는 필터 {0}(을)를 삭제하시겠습니까?",
  "OnlineHelp": "온라인 도움말",
  "Done": "완료",
  "SaveFacetState": "이 패싯 상태를 저장",
  "ClearFacetState": "패싯 상태 지우기",
  "DisplayingTheOnlyMessage": "이 대화에서 유일한 메시지를 표시",
  "NoNetworkConnection": "네트워크에 연결할 수 없습니다",
  "UnknownConnection": "알 수 없는 연결",
  "EthernetConnection": "이더넷 연결",
  "WiFi": "WiFi 연결",
  "CELL": "휴대 전화 연결",
  "CELL_2G": "휴대 전화 2G 연결",
  "CELL_3G": "휴대 전화 3G 연결",
  "CELL_4G": "휴대 전화 4G 연결",
  "Relevance": "관련성",
  "Date": "날짜",
  "Amount": "금액",
  "QueryExceptionNoException": "예외가 없습니다",
  "QueryExceptionInvalidSyntax": "구문이 잘못되었습니다",
  "QueryExceptionInvalidCustomField": "사용자 정의 필드가 잘못되었습니다",
  "QueryExceptionInvalidDate": "날짜가 잘못되었습니다",
  "QueryExceptionInvalidExactPhrase": "일치하여야 하는 구가 잘못되었습니다",
  "QueryExceptionInvalidDateOp": "날짜 연산자가 잘못되었습니다",
  "QueryExceptionInvalidNear": "NEAR 연산자가 잘못되었습니다",
  "QueryExceptionInvalidWeightedNear": "가중 NEAR 연산자가 잘못되었습니다",
  "QueryExceptionInvalidTerm": "용어가 잘못되었습니다",
  "QueryExceptionTooManyTerms": "용어가 너무 많습니다",
  "QueryExceptionWildcardTooGeneral": "와일드카드가 너무 일반적입니다",
  "QueryExceptionInvalidSortField": "정렬 필드가 잘못되었습니다",
  "QueryExceptionInvalidSmallStringOp": "단문자열 연산자가 잘못되었습니다",
  "QueryExceptionRequestedResultsMax": "요청 결과 최대 한도",
  "QueryExceptionAggregatedMirrorDead": "집합 미러가 오프라인입니다",
  "QueryExceptionAggregatedMirrorQueryTimeOut": "집합 미러 쿼리 시간 제한",
  "QueryExceptionAggregatedMirrorInvalidBuildNumber": "집합 미러의 잘못된 빌드 번호",
  "QueryExceptionAggregatedMirrorCannotConnect": "집합 미러를 연결할 수 없습니다",
  "QueryExceptionNotEnoughLeadingCharsWildcard": "선행 문자 와일드카드가 충분하지 않습니다",
  "QueryExceptionSecurityInverterNotFound": "보안 인버터를 찾을 수 없습니다",
  "QueryExceptionSecurityInverterAccessDenied": "보안 인버터 접근이 거부됐습니다",
  "QueryExceptionAggregatedMirrorCannotImpersonate": "집합 미러를 가장할 수 없습니다",
  "QueryExceptionUnexpected": "예상하지 않은",
  "QueryExceptionAccessDenied": "접근이 거부됐습니다",
  "QueryExceptionSuperUserTokenInvalid": "슈퍼 유저 토큰이 잘못되었습니다",
  "QueryExceptionSuperUserTokenExpired": "슈퍼 유저 토큰이 만료됐습니다",
  "QueryExceptionLicenseQueriesExpired": "쿼리 라이선스가 만료됐습니다",
  "QueryExceptionLicenseSuperUserTokenNotSupported": "지원하지 않는 라이선스 슈퍼 유저 토큰입니다",
  "QueryExceptionInvalidSession": "세션이 잘못됐습니다",
  "QueryExceptionInvalidDocument": "문서가 잘못됐습니다",
  "QueryExceptionSearchDisabled": "검색 사용 안 함",
  "FileType": "파일 형식",
  "ShowAttachment": "첨부 표시",
  "OnFeed": "{0}의 피드.",
  "Author": "작성자",
  "NoTitle": "제목 없음",
  "CurrentSelections": "현재 선택",
  "AllContent": "모든 콘텐츠",
  "CancelLastAction": "마지막 실행 취소",
  "SearchTips": "검색 요령",
  "CheckSpelling": "핵심어의 철자를 확인합니다.",
  "TryUsingFewerKeywords": "키워드를 더 적게 또는 다양하게 사용하거나 더 일반적인 키워드를 사용해봅니다",
  "SelectFewerFilters": "필터를 줄여 검색 범위를 넓힙니다.",
  "Document": "문서",
  "Time": "시간",
  "StartDate": "시작 날짜",
  "StartTime": "시작 시간",
  "DurationTitle": "표시 시간",
  "UserQuery": "사용자 쿼리",
  "ShowUserActions": "사용자 작업 보이기",
  "NoData": "데이터가 없습니다",
  "EventType": "이벤트 유형",
  "GoToFullSearch": "전체 검색",
  "GoToEdition": "패널 사용자 지정",
  "RemoveContext": "컨텍스트 제거",
  "BoxAttachToCase": "요청에 연결",
  "AttachToCase": "요청에 연결",
  "Attach": "연결",
  "Attached": "연결됨",
  "Detach": "분리",
  "Details": "세부 정보",
  "AdditionalFilters": "추가 필터",
  "SelectNonContextualSearch": "검색 범위를 넓히려면 현재 레코드에서 컨텍스트를 제거하십시오",
  "CopyPasteToSupport": "자세한 정보를 원하시면 이 메시지를 복사하고 붙여 넣어 Coveo 지원팀에 보내십시오.",
  "FollowQueryDescription": "이 쿼리의 검색 결과에 대한 변경 내용을 내게 알려줍니다.",
  "SearchAlerts_Panel": "알림 관리",
  "SearchAlerts_PanelDescription": "사용자의 검색 알림을 보고 관리합니다.",
  "SearchAlerts_PanelNoSearchAlerts": "구독이 없습니다.",
  "SearchAlerts_Fail": "검색 알림 서비스를 현재 사용할 수 없습니다.",
  "SearchAlerts_Type": "유형",
  "SearchAlerts_Content": "내용",
  "SearchAlerts_Actions": "작업",
  "EmptyQuery": "<비어 있음>",
  "SearchAlerts_Type_followQuery": "쿼리",
  "SearchAlerts_Type_followDocument": "항목",
  "SearchAlerts_unFollowing": "팔로잉 중지",
  "SearchAlerts_follow": "팔로우",
  "SearchAlerts_followed": "팔로우함",
  "SearchAlerts_followQuery": "쿼리 팔로우",
  "Subscription_StopFollowingQuery": "쿼리 팔로잉 중지",
  "SearchAlerts_Frequency": "언제",
  "SubscriptionsManageSubscriptions": "알림 관리",
  "SubscriptionsMessageFollowQuery": "쿼리 <b>{0}</b>(이)가 새 항목이나 업데이트된 항목을 반환할 때 알림을 받습니다.",
  "SubscriptionsMessageFollow": "항목 <b>{0}</b>의 변경 내용에 대한 알림을 받습니다.",
  "Expiration": "만료",
  "Monthly": "매월",
  "Daily": "매일",
  "Monday": "월요일",
  "Tuesday": "화요일",
  "Wednesday": "수요일",
  "Thursday": "목요일",
  "Friday": "금요일",
  "Saturday": "토요일",
  "Sunday": "일요일",
  "NextDay": "다음 {0}",
  "LastDay": "지난 {0}",
  "StartTypingCaseForSuggestions": "가능한 솔루션을 보려면 문제를 설명하십시오",
  "ExportToExcel": "엑셀로 내부내기",
  "ExportToExcelDescription": "검색 결과를 엑셀로 내보내기",
  "CaseCreationNoResults": "권장 솔루션이 없습니다",
  "SortBy": "정렬 기준",
  "BoxCreateArticle": "문서 만들기",
  "Facets": "패싯",
  "AdvancedSearch": "고급 검색",
  "Keywords": "키워드",
  "AllTheseWords": "이 모든 단어",
  "ExactPhrase": "이와 똑같은 어구",
  "AnyOfTheseWords": "이 단어 중 어느 것이든",
  "NoneOfTheseWords": "이 단어 중 아무것도 없음",
  "Anytime": "항상",
  "InTheLast": "최근",
  "Days": "일",
  "Months": "개월",
  "Month": "월",
  "Year": "연",
  "Between": "사이",
  "Language": "언어",
  "Size": "크기",
  "AtLeast": "최소",
  "AtMost": "최대",
  "Contains": "포함",
  "DoesNotContain": "(이)가 없습니다",
  "Matches": "일치",
  "Bytes": "바이트",
  "card": "카드",
  "table": "표",
  "ResultLinks": "결과 링크",
  "EnableQuerySyntax": "쿼리 구문 사용",
  "On": "켬",
  "Off": "끔",
  "Automatic": "자동",
  "ResultsPerPage": "페이지당 결과 표시",
  "PreviousMonth": "이전 달",
  "NextMonth": "다음 달",
  "Title": "제목",
}

  var locales = String["locales"] || (String["locales"] = {});
  locales["ko"] = merge(locales["ko"], dict);
  String["toLocaleString"].call(this, { "ko": dict });
  String["locale"] = "ko";
  String["defaultLocale"] = "en";
  Globalize.culture("ko")
}